%a function use Single Continuous Perceptron Training Algorithm (SCPTA)
%parameter "data" is a matrix with input and real output
%data = [i1 i2 i3 ; i1 i2 i3 ; o1 o2 o3]
%return single layer weight "w"
%w = [w1 w2 w3]

function w = SCPTA(data)
[dimension, pattern_num] = size(data);

term_error = 0.001;
max_iter = 1000;
max_constant = 100;
train_para = 1;

wtemp = 2*rand(1, dimension)-1;
w = wtemp;

real_output = data(dimension, :);
data(dimension, :) = 1;

error_num = pattern_num;
error = 1;
iter = 1;
const_iter = 0;

while (iter <= max_iter) & (error > term_error) & (error_num ~= 0) & (const_iter <= max_constant)
   error = 0;
   for i = 1 : pattern_num
      output = bipolar_con_fun(wtemp*data(:,i));
      wtemp = wtemp + train_para*0.5*(real_output(i)-output)*(1-output^2)*data(:, i)';
      error = error + 0.5*((real_output(i) - output)^2);
   end
   
   %pocket algorithm
   
   output = sign(wtemp*data);
   output(find(output==0)) = -1;
   count = sum(abs(output-real_output))/2;
   if count < error_num
      w = wtemp;
      error_num = count;
      const_iter = 0;
   else
      const_iter = const_iter + 1;
   end
   
   iter = iter + 1;
end
      
      
      
   




